@echo off

echo %0 
echo called with parameters:  p1=%1 and p2=%2 
 
:: The PicoHarp 330 software will always start a sequence with 
:: p1=0 and increment it at each new call, up to the 
:: maximum of 511, corresponding to the max number of 
:: 512 curves in a PHU file.

:: Here you would put your code for e.g. setting a monochromator
:: making use of callparam to e.g. encode the wavelength.
:: The PicoHarp software will always start a sequence with 
:: callparam 0 and increment it at each new call.
:: You could do something like
::     wavelength = startwavelength + callparam * wavelengthstep
:: and then set your monochromator accordingly.

:: You can also return a value for recording in the PHU data file. 
:: You can return any positive 32-bit integer, 
:: for instance, following the example above, to indicate a wavelength. 
:: Negative values are reserved for error codes and will cause the 
:: measurement sequence to be aborted.
:: Just for demo purposes we return callparam + 1000:

set /a returncode = %1 + 1000
echo returncode will be %returncode%

:: Also only for demo purposes we just waste some time here
timeout 10

exit %returncode%
